/*! https://mths.be/cssescape v1.5.1 by @mathias | MIT license */


/**
 * This regex consists of 4 matching capture groups and one (non-matching) fallback:
 *
 * - (\0), catch the null terminator character so it may be replaced by UTF
 *   Replacement Char
 * - ^(-)$, catch a solitary dash char, so that it may be backslash escaped.
 *   This is a separate capture group so that the legal-chars (group 4) doesn't
 *   capture it first, since that group doesn't need to escape its dash.
 * - ([\x01-\x1f\x7f]|^-?[0-9]), catch a UTF control char, or any leading
 *   number (with an optional leading dash). The control or the number (but not
 *   the leading dash) must be hex-escaped,.
 * - ([\x80-\uffff0-9a-zA-Z_-]+), catch legal-chars, with the exception of a
 *   solitary dash, which will already have matched in group 1.
 * - [^], finally, a catch-all that allows us to backslash escape the char.
 *
 * Together, this matches everything necessary for CSS.escape.
 */
var regex = /(\0)|^(-)$|([\x01-\x1f\x7f]|^-?[0-9])|([\x80-\uffff0-9a-zA-Z_-]+)|[^]/g;

function escaper(match, nil, dash, hexEscape, chars) {
    // Chars is the legal-chars (group 4) capture
    if (chars) {
        return chars;
    }
    // Nil is the null terminator (group 1) capture
    if (nil) {
        return '\uFFFD';
    }
    // Both UTF control chars, and leading numbers (with optional leading dash)
    // (group 3) must be backslash escaped with a trailing space.  Funnily, the
    // leading dash must not be escaped, but the number. :shrug:
    if (hexEscape) {
        return match.slice(0, -1) + '\\' + match.slice(-1).charCodeAt(0).toString(16) + ' '
    }
    // Finally, the solitary dash and the catch-all chars require backslash
    // escaping.
    return '\\' + match;
}

/**
 * https://drafts.csswg.org/cssom/#serialize-an-identifier
 * @param {string} value
 * @return {string}
 */
export function cssEscape(value) {
    return String(value).replace(regex, escaper);
}